;BIOS32 structures include file
;written by John Baldwin for Phoenix Systems, Inc. (name?), 1997

DISPLAY "    BIOS32 Structures and Equates"

BIOS32_START_SEARCH EQU      0E0000h   ;where to start searching for BIOS32
BIOS32_STOP_SEARCH EQU       0FFFFFh   ;where to stop searching for BIOS32

STRUC BIOS32_DATA_STRUCTURE            ;BIOS32 Service Directory data structure
 Signature         DB        4 DUP(?)  ;signature field
 EntryPoint        DD        ?         ;32-bit physical entry point
 RevisionLevel     DB        ?
 Length            DB        ?         ;length of structure in paragraphs
 CheckSum          DB        ?         ;all data added up must = 0
 Reserved          DB        5 DUP(0)  ;reserved, must be 0
ENDS  BIOS32_DATA_STRUCTURE

BIOS32_SIGNATURE   EQU       '_23_'    ;valid signature

STRUC BIOS32_ServiceEntry
 Base              DD        ?
 Length            DD        ?
 EntryPoint        DD        ?
ENDS  BIOS32_ServiceEntry

;Entry Point  - CALL FAR
;-----------
;Regs at call:                         Returns:
;   EAX = Service Identifier              AL  = Status
;   BL  = Function                                 00h - Successful
;            00h - get information                 80h - Unsupported service
;                                                  81h - Unsupported function
;                                         EBX = Physical Address of BIOS service base
;                                         ECX = Length of BIOS service
;                                         EDX = Offset of entry point from EBX
;
;Notes: Use EBX & ECX to set up an execute-only selector for CS and a read-only
;selector for DS for use when calling the service functions.  Then just call far to
;CS:EDX to call the service
