//Program GetBIOS32Info

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include "biosinfo.h"

#pragma inline

#define Yes        "Yes"
#define No         "No"
#define Found      "found at "
#define NotFound   "not found"
#define DoubleLine ""
#define SingleLine ""

#define ZERO       0
#define ONE        1
#define TWO        2
#define FOUR       4
#define SEVEN      7
#define SIXTEEN    16

extern  unsigned   _stklen = 16384; /* 16k stack */

PBIOSDataTable BIOSDataTable;

void ClearScreen(void)
{
   asm {
      mov ax,0x0003
      int 0x10
   };
};

void Init(void)

{
   ClearScreen();
   printf("BIOSInfo v1.0 - written by John H. Baldwin 1996-1997.\n");
   printf(SingleLine);
   printf("\nThis program requires a 386 that is running in Real Mode, not Protected Mode.\n");
   printf("So, if you are in Windows, OS/2, NT, etc., this program will most definitely\n");
   printf("bomb when it tries to execute.  Also, using memory managers such as EMM386 will\n");
   printf("bomb as well.  Finally, if you run this on a 286 or below it will definitely\n");
   printf("bomb.  If your computer does blow up, it's NOT my fault, you use this program\n");
   printf("at your own risk.  if you want to abort now, hit Ctrl-Break, otherwise press\n");
   printf("Enter to continue...\n\n");
   while(getch()!='\r');
   printf("Ok, you have chosen to run this anyway, so here goes...\n\n");
};

void Pause(void)

{
   printf("Press Enter to continue...");
   while(getch()!='\r');
};

void DisplayGenericData(void)
{
   Byte Loop;

   ClearScreen();
   printf("What you have\n");
   printf(DoubleLine);
   printf("\n");
   printf("BIOS32 Extensions  -> ");
   if (BIOSDataTable->BIOS32Location!=NULL)
      {
         printf(Found);
         printf("%08lXh\n",BIOSDataTable->BIOS32Location);
         printf("   PCI BIOS        -> ");
         if (BIOSDataTable->PCIInfo.Base!=NULL)
            printf(Yes);
         else
            printf(No);
         printf("\n   PnP ACF BIOS    -> ");
         if (BIOSDataTable->ACFInfo.Base!=NULL)
            printf(Yes);
         else
            printf(No);
      }
   else
      printf(NotFound);
   printf("\nPlug 'n' Play BIOS -> ");
   if (BIOSDataTable->PnPLocation!=NULL)
      {
         printf(Found);
         printf("%08lXh\n",BIOSDataTable->PnPLocation);
      }
   else
      printf(NotFound);
   printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
   if(BIOSDataTable->BIOS32Location==NULL)
      printf("\n\n");
   Pause();
};

void DisplayBIOS32Data(void)
{
   PBIOS32Data BIOS32Data;
   Byte        Loop;

   ClearScreen();
   printf("BIOS32, PCI BIOS, and PnP Autoconfiguration (ACF) BIOS Information\n");
   printf(DoubleLine);
   BIOS32Data=(PBIOS32Data)ConvertFlatToReal((Pointer)BIOSDataTable->BIOS32Location);
   printf("\nBIOS32:\n");
   printf("Signature        -> ");
   for(Loop=ZERO; Loop<FOUR; Loop++)
      printf("%c",BIOS32Data->Signature[Loop]);
   printf("\nEntry Point      -> %08lXh\n",BIOS32Data->EntryPoint);
   printf("Revision Level   -> %02Xh\n",BIOS32Data->RevisionLevel);
   printf("Structure Length -> %02Xh Paragraphs\n",BIOS32Data->Length);
   if (BIOSDataTable->PCIInfo.Base!=NULL)
      {
         printf("\nPCI BIOS32 Service:\n");
         printf("Base             -> %08lXh\n",BIOSDataTable->PCIInfo.Base);
         printf("Length           -> %08lXh\n",BIOSDataTable->PCIInfo.Length);
         printf("Entry Point      -> %08lXh\n",BIOSDataTable->PCIInfo.EntryPoint);
      }
   else
      printf("\n\n\n\n\n\n");
   if (BIOSDataTable->ACFInfo.Base!=NULL)
      {
         printf("\nPnP ACF BIOS32 Service:\n");
         printf("Base             -> %08lXh\n",BIOSDataTable->ACFInfo.Base);
         printf("Length           -> %08lXh\n",BIOSDataTable->ACFInfo.Length);
         printf("Entry Point      -> %08lXh\n",BIOSDataTable->ACFInfo.EntryPoint);
      }
   else
      printf("\n\n\n\n\n\n");
   printf("\n\n\n");
   Pause();
};

void DisplayPnPData(void)

{
   PPnPInfo PnPInfo;
   Byte     Loop;

   ClearScreen();
   printf("Plug 'n' Play BIOS Information\n");
   printf(DoubleLine);
   printf("\n");
   PnPInfo=(PPnPInfo)ConvertFlatToReal((Pointer)BIOSDataTable->PnPLocation);
   printf("Signature               -> ");
   for(Loop=ZERO; Loop<FOUR; Loop++)
      printf("%c",PnPInfo->Signature[Loop]);
   printf("\nVersion                 -> %d.%d\n",PnPInfo->Version >> FOUR,
                                                 PnPInfo->Version & 0x0F);
   printf("Length                  -> %02Xh\n",PnPInfo->Length);
   printf("Event Handling          -> ");
   switch (PnPInfo->ControlField & 0x0003) {
      case ZERO : printf("None\n");
                  break;
      case ONE  : printf("Polling\n");
                  printf("   Event Flag Address   -> %lX\n",PnPInfo->EventNotifyFlag);
                  break;
      case TWO  : printf("Asynchronous\n");
                  break;
      default   : printf("Unknown!\n");
   };
   printf("OEM Device ID           -> %08lXh\n",PnPInfo->OEMDeviceID);
   printf("Real Mode Entry Point   -> %04X:%04X\n",long(PnPInfo->RealModeEntryPoint) >> SIXTEEN,
                                               long(PnPInfo->RealModeEntryPoint) & 0xFFFF);
   printf("Real Mode Data Segment  -> %04Xh\n",PnPInfo->RealModeDataSeg);
   printf("Protected Mode 16-bit Entry Point\n");
   printf("   Base                 -> %08lXh\n",PnPInfo->PM16EntrySegBase);
   printf("   Offset               -> %04Xh\n",PnPInfo->PM16EntryOffset);
   printf("PM 16 Data Segment Base -> %08lXh\n",PnPInfo->PM16DataSegBase);
   for(Loop=ZERO; Loop<SEVEN; Loop++)
      printf("\n");
   if((PnPInfo->ControlField & 0x0003)!=ONE)
      printf("\n");
   Pause();
};

void DisplayData(void)

{
   DisplayGenericData();
   if(BIOSDataTable->BIOS32Location!=NULL)
      DisplayBIOS32Data();
   if(BIOSDataTable->PnPLocation!=NULL)
      DisplayPnPData();
};

void GetData(void)

{
   ClearScreen();
   printf("Fetching Data...\n");
   printf(SingleLine);
   printf("\n");
   printf("If the computer locks up or you get weird messages (like a core dump), then you\n");
   printf("need to reboot.  If you get an exception from EMM386, Windows, etc. then learn\n");
   printf("to read and don't try to run this if the processor is already in\n");
   printf("Protected Mode.\n\n");
   printf("Jumping into 32-bit Protected Mode to go snooping... :)\n\n");
   if(CheckForPM())
      {
         printf("\7You idiot! Can you not read?!?  You are already in Protected Mode!\n\n");
         exit(1);
      }
   BIOSDataTable=GetBIOSInfo();
   printf("\nWell, we made it back, press Enter to see what spiffy stuff you have...\n");
   while(getch()!='\r');
};

void main()
{
   Init();
   GetData();
   DisplayData();
};

