;CPUINFO.ASM - library for using CPUID to find out info on CPU
;written by John Baldwin, 1996
MODEL Small
IDEAL
P386

BitShift   EQU     21
CPUIDBit   EQU     (1 shl BitShift)

MACRO      cpuid

           db      0Fh,0A2h

ENDM

CODESEG

PUBLIC     CPUIDThere                   ;Function CPUIDThere:Boolean;
PUBLIC     RunCPUID                     ;Procedure RunCPUID(Index:LongInt; var Data:CPUInfoRec);

PROC       CPUIDThere FAR

           pushfd                       ;push EFLAGS onto the stack
           pop     eax                  ;and copy them to EAX
           mov     ebx,eax              ;copy to EBX as well
           xor     eax,CPUIDBit         ;toggle CPUIDBit to see if CPUID
                                        ;is supported
           push    eax                  ;put EAX on the stack
           popfd                        ;and try to toggle the bit in
                                        ;the EFLAGS register
           pushfd                       ;now put EFLAGS back on stack
           pop     eax                  ;and copy them to eax
           xor     eax,ebx              ;see if they are different, if so
                                        ;then EAX = CPUIDBit, otherwise
                                        ;EAX = 0
           shr     eax,BitShift         ;now move CPUIDBit to bit 0 to
                                        ;return boolean in AL.0
           retf                         ;that's all folks

ENDP

PROC       RunCPUID FAR

;=======================================
;STACK FRAME
;---------------------------------------
; Offset   Description
; -------  -----------------------------
; [bp]     old BP
; [bp+02]  old CS
; [bp+04]  old IP
; [bp+06]  Far Pointer to returned Data
; [bp+0A]  Index value
;---------------------------------------

           push    bp
           mov     bp,sp                ;set up stack frame
           mov     eax,[bp+0Ah]         ;put Index in EAX
           cpuid                        ;run CPUID
           les     di,[bp+06h]          ;ES:DI -> Data
           mov     [es:di],eax          ;save EAX
           mov     [es:di+04h],ebx      ;save EBX
           mov     [es:di+08h],ecx      ;save ECX
           mov     [es:di+0Ch],edx      ;save EDX
           pop     bp                   ;shut down stack frame
           retf                         ;bye-bye

ENDP

ENDS

END