{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
Unit FATMgr;

Interface

Const
   {Signatures}
   MBRSignature= $AA55;
   DPBSignature= MBRSignature;

   {System IDs}
   siEmpty=      $00;
   siDos12=      $01;
   siXenixFile=  $02;
   siXenixUsr=   $03;
   siDos16=      $04;
   siDosExtended=$05;
   siDos16Big=   $06;
   siOS2_HPFS=   $07;
   siWinNT_NTFS= $07;
   siAIXBoot=    $08;
   siAIXData=    $09;
   siOS2_Boot=   $0A;
   siDiskManager=$51;
   siCPM=        $52;
   siGB=         $56;
   siSpeedStor=  $61;
   siSysV386=    $63;
   siNovell=     $64;
   siPC_IX=      $75;
   siMinix=      $80;
   siMinix15=    $81;
   siCPM2=       $DB;
   siSpeedStor12=$E1;
   siSpeedStor16=$E4;
   siLANStep=    $FE;
   siBadBlocks=  $FF;

   {Media Descriptors}
   mdFixedDisk=  $F8;
   mdFloppyDisk= $F9;

   {Special Clusters}
   clFree=       $0000;
   clBad=        $FFF7;
   clEOFMask=    $FFF8;

   {File Attributes}
   faReadOnly=   $01;
   faHidden=     $02;
   faSystem=     $04;
   faVolumeLabel=$08;
   faDirectory=  $10;
   faArchive=    $20;

   {Special Sector Numbers}
   MBRSector=    $00000001;

Type
   {Master Boot Record types}
   PartitionRecord=Record
                      BootIndicator, {bit 7 is boot indicator}
                      StartHead,
                      StartSector,
                      StartCylinder,
                      SystemID,
                      EndHead,
                      EndSector,
                      EndCylinder:Byte
                      PrecedingSectors,
                      LengthInSectors:LongInt;
                   End;

   MasterBootRecord=Record
                       BootStrap:Array[1..446] of Byte;
                       Partitions:Array[0..3] of PartitionRecord;
                       Signature:Word;
                    End;

   {Boot Sector types}
   DriveParameterBlock=Record
                          OEMDescription:Array[1..8] of Char;
                          BytesPerSector:Word;
                          SectorsPerCluster:Byte;
                          ReservedSectors:Word;
                          NumFATs:Byte;
                          NumRootDirEntries,
                          TotalSectors:Word;
                          MediaDescriptor:Byte;
                          NumFATSectors,
                          NumSectorsPerTrack,
                          NumHeads:Word;
                          NumSpecialSectors,
                          Total32Sectors:LongInt;
                          DriveNumber:Word;
                          ExtendedBootSignature:Byte;
                          VolumeSerialNumber:LongInt;
                          VolumeLabel:Array[1..11] of Char;
                          FileSystemID:Array[1..8] of Char;
                       End;

   BootSector=Record
                 JumpInstr:Array[1..3] of Byte;
                 DPB:DriveParameterBlock;
                 BootStrapProgram:Array[1..448] of Byte;
                 Signature:Word;
              End;

   {Directory Entry type}
   DirectoryEntry=Record
                     FileName:Array[1..8] of Char;
                     Extension:Array[1..3] of Char;
                     Attributes:Byte;
                     Reserved:Array[1..10] of Byte;
                     Time,
                     Date,
                     StartCluster:Word;
                     ByteSize:LongInt;
                  End;

Procedure