{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
Unit FileType;

Interface

Const
   NumHeadings=3;
   FormatChar='';
   BufferSize=32768;

   {Headings}
   he1=$01;
   he2=$02;
   he3=$03;

   {Attributes}
   atNormal    =$00;
   atBold      =$01;
   atUnderline =$02;
   atCentered  =$04;
   atFlushRight=$08;
   at

Type
   PFileFormat=^TFileFormat;
   TFileFormat=Object
                  OutFile:TFile;
                  Extension:String[3];
                  Constructor Init(FileName:String);
                  Procedure ParseLine(Line:String);
                  Destructor Done; virtual;
                  Private
                  Next:PFileFormat;

                  Function SetExtension(Name:String):String;
                  Procedure FileStart; virtual;
                  Function FormatLine(Line:String):Byte; virtual;
                  Procedure FormatHeading; virtual;
               End;

Implementation

Constructor TFileFormat.Init(Name:String);

Begin
   Name:=Name+'.'+Extension;
   OutFile.Init(Name,BufferSize);
   OutFile.RewriteFile;
   FileStart;
End;

Procedure ParseLine(Line:String);

Begin


Procedure Text3(Line:String); Far;

Var
   Loop:Byte;

Begin
   OutFile.OutLn(Line);
   For Loop:=1 to Length(Line) Do
      OutFile.OutChar('');
   OutFile.NewLine;
End;


Procedure HTML1(Line:String); Far;

Begin
   OutFile.Out('<H1>');
   OutFile.Out(Line);
   OutFile.OutLn('</H1>');
End;

Procedure HTML2(Line:String); Far;

Begin
   OutFile.Out('<H2>');
   OutFile.Out(Line);
   OutFile.OutLn('</H2>');
End;

Procedure HTML3(Line:String); Far;

Begin
   OutFile.Out('<H3>');
   OutFile.Out(Line);
   OutFile.OutLn('</H3>');
End;

Const
   TXTFiles :TFileType = (Extension: 'TXT'; Headings: (Text1, Text2, Text3));
   HTMLFiles:TFileType = (Extension: 'HTM'; Headings: (HTML1, HTML2, HTML3));

Procedure FormatLine(Line:String);

Var
   Heading:Byte;

Begin
   If (Line[1]=FormatChar) Then
      If (Length(Line)>1) and (Line[2] in ['1'..MaxHeading]) Then
         Begin
            Heading:=Byte(Line[2])-Byte('0');
            Delete(Line,1,2);
            Format.Headings[Heading](Line);
            {OutFile.NewLine;}
            Exit;
         End;
   OutFile.OutLn(Line);
End;

