{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
{$M 4096,98304,98304}
Program ParseInstructionLists;

Uses
   StrProcs,TextBuf;

Const
   InputExtension='DOC';
   MaxHeadings=3;
   MaxHeading=Char(MaxHeadings+Byte('0'));
   FormatChar='';
   BufferSize=32768;
   MaxFormats=2;

Type
   THeading=Procedure (Line:String; OutFile:PFile);
   THeadings=Array[0..MaxHeadings] of THeading;
   PFileType=^TFileType;
   TFileType=Object
                Extension:String[3];
                Headings:THeadings;
                Next:PFileType;
                Constructor Init(FileName:String);
                Destructor Done;
                Procedure ParseLine(Line:String; Heading:Byte);
                Private
                OutFile:PFile;
             End;
Var
   AllDone:Boolean;
   InFile:Text;

Constructor TFileType.Init(FileName:String);

Begin
   New(OutFile,Init(FileName+Extension,BufferSize));
   If Next<>Nil Then
      Next^.Init(FileName);
End;

Destructor TFileType.Done;

Begin
   If Next<>Nil Then
      Next^.Done;
   Dispose(OutFile,Done);
End;

Procedure TFileType.ParseLine(Line:String; Heading:Byte);

Begin
   Headings[Heading](Line,OutFile);
   If Next<>Nil Then
      Next^.ParseLine(Line,Heading);
End;

Procedure NoFormat(Line:String; OutFile:PFile); Far;

Begin
   OutFile^.OutLn(Line);
End;

Procedure Text1(Line:String; OutFile:PFile); Far;

Var
   Loop,Len:Byte;

Begin
   OutFile^.OutChar('');
   Len:=Length(Line)+2;
   For Loop:=1 to Len Do
      OutFile^.OutChar('');
   OutFile^.OutChar('');
   OutFile^.NewLine;
   OutFile^.OutChar('');
   OutFile^.OutChar(' ');
   OutFile^.Out(Line);
   OutFile^.OutChar(' ');
   OutFile^.OutChar('');
   OutFile^.NewLine;
   OutFile^.OutChar('');
   For Loop:=1 to Len Do
      OutFile^.OutChar('');
   OutFile^.OutChar('');
   OutFile^.NewLine;
End;

Procedure Text2(Line:String; OutFile:PFile); Far;

Var
   Loop:Byte;

Begin
   OutFile^.OutLn(Line);
   For Loop:=1 to Length(Line) Do
      OutFile^.OutChar('');
   OutFile^.NewLine;
End;

Procedure Text3(Line:String; OutFile:PFile); Far;

Var
   Loop:Byte;

Begin
   OutFile^.OutLn(Line);
   For Loop:=1 to Length(Line) Do
      OutFile^.OutChar('');
   OutFile^.NewLine;
End;

Procedure HTML1(Line:String; OutFile:PFile); Far;

Begin
   OutFile^.Out('<H1>');
   OutFile^.Out(Line);
   OutFile^.OutLn('</H1>');
End;

Procedure HTML2(Line:String; OutFile:PFile); Far;

Begin
   OutFile^.Out('<H2>');
   OutFile^.Out(Line);
   OutFile^.OutLn('</H2>');
End;

Procedure HTML3(Line:String; OutFile:PFile); Far;

Begin
   OutFile^.Out('<H3>');
   OutFile^.Out(Line);
   OutFile^.OutLn('</H3>');
End;

Const
   TXTFiles :TFileType =
      (Extension: 'TXT'; Headings: (NoFormat, Text1, Text2, Text3); Next: NIL);
   HTMLFiles:TFileType =
      (Extension: 'HTM'; Headings: (NoFormat, HTML1, HTML2, HTML3); Next: @TXTFiles);
   FirstFormat:PFileType = @HTMLFiles;

Procedure FormatLine(Line:String);

Var
   Heading:Byte;

Begin
   Heading:=0;
   If (Line[1]=FormatChar) Then
      If (Length(Line)>1) and (Line[2] in ['1'..MaxHeading]) Then
         Begin
            Heading:=Byte(Line[2])-Byte('0');
            Delete(Line,1,2);
         End;
   FirstFormat^.ParseLine(Line,Heading);
End;

Function ReadNextLine:String;

Var
   S:String;

Begin
   S:='';
   If EOF(InFile) Then
      AllDone:=True
   Else
      Readln(InFile,S);
End;

Procedure ProcessFile;

Begin
   Repeat
      FormatLine(ReadNextLine);
   Until AllDone;
End;

Function GetName(Name:String):String;

Var
   Loop,Index:Byte;

Begin
   Index:=0;
   If Length(Name)>4 Then
      Index:=Length(Name)-4;
   For Loop:=4 downto 1 Do
      If (Name[Index+Loop]='.') and (Loop+Index<=Byte(Name[0])) Then
         Begin
            Name[0]:=Char(Index+Loop);
            Break;
         End;
End;

Procedure Help;

Begin
   Writeln('Opcodes Parse v1.0 - written by John Baldwin, 1996'#13#10+
           #10+
           'Syntax:'#13#10+
           #10+
           '   Parse <InFile>'#13#10+
           #10+
           'Where InFile is the name of the file to parse.  If no extension is specified,'#13#10+
           'then .'+InputExtension+' will be assumed as the extension.');
   Halt(1);
End;

Procedure ParseCmdLine;

Var
   BaseName,Name:String;

Begin
   If ParamCount<>1 Then
      Help;
   Name:=UpStr(ParamStr(1));
   BaseName:=GetName(Name);
   If Name=BaseName Then
      Name:=Name+InputExtension;
   Assign(InFile,Name);
   {$I-} Reset(InFile); {$I+}
   If IOResult<>0 Then
      Begin
         Writeln(#7'Could not find input file ',Name,'.');
         Halt(2);
      End;
   FirstFormat^.Init(BaseName);
End;

Begin
   ParseCmdLine;
   ProcessFile;
   FirstFormat^.Done;
End.
