{Abstraction level for Segments, also handles organization of a single
 PFS partition in a Boot Record}

{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
Unit PFSSegments;

Interface

Uses
   PFSTypes,PFSDrivers;

{Here we handle partitions and PFS segments.  The partitions are stored in
 an internal linked list ordered by number.  Segments are also stored in an
 internal linked-list ordered by number.}

(**************************************************************************)

{Error codes}
Const
   PFS_ecPartitionFull   =$0010; {no more space for another segment}
   PFS_ecMaxSegments     =$0011; {already have 8 segments in a partition}
   PFS_ecInvalidSegment  =$0012; {not a valid segment}
   PFS_ecInvalidPartition=$0013; {not a valid partition}
   PFS_ecRegionOutOfRange=$0014; {tried to create a segment in a partition
                                  that was not empty}
   PFS_ecRegionNotEmpty  =$0015; {tried to create a segment in a non-empty
                                  region}

(**************************************************************************)

{Puts a segment table in a PFS partition}
Function PFS_InitializePartition(Partition:Word):Word;
{Adds a segment to a PFS partition}
Function PFS_AddSegment(Partition:Word;
                        Start,Size:TPFS_LogicalSectorNumber):Word;
{Formats a PFS segment}
Function PFS_FormatSegment(Segment:Word):Word;
{Reads all partitions and PFS segments from a drive.}
Function PFS_ReadPartitions(Drive:Word):Word;
{Writes all partitions and PFS segment tables to a drive}
Function PFS_WritePartitions(Drive:Word):Word;
{Clears all paritions and PFS segments for a drive from memory}
Function PFS_ClearPartitions(Drive:Word):Word;

Implementation

(**************************************************************************)

{Internal linked-list of partitions}

Type
   PPartitionRecord=^TPartitionRecord;
   TPartitionRecord=Record
                 {00}  PartitionNumber:Word; {global number}
                 {02}  DriveNumber:Word;
                 {04}  DrivePartitionNumber:Byte; {relative to drive}
                       {000xxxxx
                           ^^^^^
                           |||||
                           |||`- Partition number
                           `---- Boot record}
                 {05}  Bootable:Byte;
                 {06}  SystemID:Byte;
                 {07}  NumSegments:Byte;  {only valid for PFS}
                 {08}  StartSector:TPFS_LogicalSectorNumber;
                 {10}  NumSectors:TPFS_LogicalSectorNumber;
                 {18}  SectorsBefore:Word;
                 {1A}  FirstSegment:Word; {only valid for PFS}
                 {1C}  NextPartition:PPartitionRecord;
                 {20}
                    End;

{Internal linked-list of segments}

Type
   PSegmentRecord=^TSegmentRecord;
   TSegmentRecord=Record
               {00}  SegmentNumber:Word;   {global number}
               {02}  PartitionNumber:Word;  {parent partition}
               {04}  StartSector:TPFS_LogicalSectorNumber;
               {08}  NumSectors:TPFS_LogicalSectorNumber;
               {0C}  NextSegmentInVolume:Word;  {global seg. number}
               {0E}  NextSegment:PSegmentRecord;
               {12}
                  End;

Const
   FirstPartition:PPartitionRecord=Nil;
   FirstSegment:PSegmentRecord=Nil;
   SegmentNumber:Word=0;
   PartitionNumber:Word=0;
   NoSegment=-1;
   NoPartition=-1;

(**************************************************************************)

Function GetPartition(Partition:Word):PPartitionRecord;

Var
   Current:PPartitionRecord;

Begin
   If (Partition=NoPartition) Then
      Begin
         GetPartition:=Nil;
         Exit;
      End;
   Current:=FirstPartition;
   While((Current<>Nil) and (Partition<Current^.PartitionNumber))
      Current:=Current^.NextPartition;
   If((Current<>Nil) and (Partition>Current^.PartitionNumber))
      Current:=Nil;
   GetPartition:=Current;
End;

(**************************************************************************)

Function GetSegment(Segment:Word):PSegmentRecord;

Var
   Current:PSegmentRecord;

Begin
   If (Segment=NoSegment) Then
      Begin
         GetSegment:=Nil;
         Exit;
      End;
   Current:=FirstSegment;
   While((Current<>Nil) and (Segment<Current^.SegmentNumber))
      Current:=Current^.NextSegment;
   If((Current<>Nil) and (Segment>Current^.SegmentNumber))
      Current:=Nil;
   GetSegment:=Current;
End;

(**************************************************************************)

Function GetFirstPartition(Drive:Word):PPartitionRecord;

Var
   P:PPartitionRecord;

Begin
   P:=FirstPartition;
   While (P<>Nil) and (P^.DriveNumber<>Drive) Do
      P:=P^.Next;
   GetFirstPartition:=P;
End;

(**************************************************************************)

Function GetNextPartition(Partition:PPartitionRecord):PPartitionRecord;

Var
   P:PPartitionRecord;

Begin
   If (Partition=Nil) Then
      Begin
         GetNextPartition:=Nil;
         Exit;
      End;
   P:=Partition^.Next;
   While (P<>Nil) and (P^.DriveNumber<>Partition^.DriveNumber) Do
      P:=P^.Next;
   GetNextPartition:=P;
End;

(**************************************************************************)

Function GetFirstSegment(Partition:Word):PSegmentRecord:

Var
   P:PPartitionRecord;

Begin
   P:=GetPartition(Partition);
   GetFirstSegment:=GetSegment(P^.FirstSegment);
End;

(**************************************************************************)

Function GetNextSegment(Segment:PSegmentRecord):PSegmentRecord;

Begin
   GetNextSegment:=GetSegment(Segment^.NextSegmentInVolume));
End;

(**************************************************************************)

Function PFS_InitializePartition(Partition:Word):Word;

Var
   P:PPartionRecord;

Begin
   P:=GetPartition(Partition);
   P^.SystemID:=PFS_PRE_idPhoenixFS;
   P^.NumSegments:=0;
   P^.FirstSegment:=NoSegment;
End;

(**************************************************************************)

Function PFS_AddSegment(Partition:Word;
                        Start,Size:TPFS_LogicalSectorNumber):Word;

Var
   P:PPartitionRecord;
   N:TPFS_LogicalSectorNumber;
   S:PSegmentRecord;

Begin
   P:=GetPartition(Partition);
   If (P=Nil) Then
      Begin
         PFS_AddSegment:=PFS_ecInvalidPartition;
         Exit;
      End;
   If (P^.NumSegments=PFS_NumberSegmentTableEntries) Then
      Begin
         PFS_AddSegment:=PFS_ecMaxSegments;
         Exit;
      End;
   N:=P^.SectorsBefore+P^.NumSectors;
   If (Size>N) or (Start>=N) or (Start+Size>N) Then
      Begin
         PFS_AddSegment:=PFS_ecRegionOutOfRange;
         Exit;
      End;
   If (P^.NumSegments>0) Then
      Begin
         S:=GetSegment(P^.FirstSegment);
         N:=Start+Size;
         While (S<>Nil) Do
            Begin
               If (S^.StartSector<N) and
                  (S^.StartSector+S^.NumSectors>Start) Then
                     Begin
                        PFS_AddSegment:=PFS_ecRegionNotEmpty;
                        Exit;
                     End;
               S:=GetNextSegment(S);
      End
   Else
      P^.FirstSegment:=SegmentNumber+1;
   Inc(P^.NumSegments);
   Inc(SegmentNumber);
   If (FirstSegment=Nil) Then
      Begin
         New(FirstSegment);
         S:=FirstSegment;
      End
   Else
      Begin
         S:=FirstSegment;
         While (S^.Next<>Nil) Do
            S:=S^.Next;
         New(S^.Next);
         S:=S^.Next;
      End;
   S^.SegmentNumber:=SegmentNumber;
   With S^ Do
      Begin
         PartitionNumber:=Partition;
         StartSector:=Start;
         NumSectors:=Size;
         NextSegmentInVolume:=NoSegment;
         NextSegment:=Nil;
      End;

End;

(**************************************************************************)

Function PFS_FormatSegment(Segment:Word):Word;

Begin
End;

(**************************************************************************)

Function PFS_ReadPartitions(Drive:Word):Word;

Begin
End;

(**************************************************************************)

Function PFS_WritePartitions(Drive:Word):Word;

Begin
End;

(**************************************************************************)

Function PFS_ClearPartitions(Drive:Word):Word;

Begin
End;

(**************************************************************************)

End.