{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
{$M 4096,0,655360}
Program TestCHS;

Uses
   PFSTypes,Crt;

Type
   TBigCHS=Record
              Cylinder:Word;
              Head,Sector:Byte;
           End;

Procedure ConvertToCHS(LogicalSector:TPFS_LogicalSectorNumber;
                       Size:TBigCHS; var CHS:TBigCHS);
Begin
   With CHS Do
      Begin
         Sector:=(LogicalSector.Lo mod Size.Sector)+1;
         LogicalSector.Lo:=LogicalSector.Lo div Size.Sector;
         Head:=LogicalSector.Lo mod (Size.Head+1);
         Cylinder:=LogicalSector.Lo div (Size.Head+1);
      End;
End;

Var
   S:TPFS_LogicalSectorNumber;
   CHS,Size:TBigCHS;
   MaxS:LongInt;

Begin
   Writeln('Enter the max values for cylinder, head, and sector.');
   Writeln('Note that the max values for cylinder and head are one less');
   Writeln('than the number of cylinders and heads, but the max value');
   Writeln('for a sector is the same as the number of sectors.');
   Writeln;
   Writeln('For example, suppose you wanted the CHS schedule for a 1.44M');
   Writeln('floppy with 40 cylinders (tracks), 2 heads (sides), and 18');
   Writeln('sectors per cylinder, then you would enter the following:');
   Writeln;
   Writeln('> 39 1 18');
   Writeln;
   Write('> ');
   With Size Do
      Begin
         Readln(Cylinder,Head,Sector);
         MaxS:=LongInt((Head+1)*Sector)*LongInt(Cylinder+1)-1;
      End;
   S.Hi:=0;
   For S.Lo:=0 to MaxS Do
      Begin
         ConvertToCHS(S,Size,CHS);
         Write('LogicalSector: ',S.Lo);
         Write(' Cyl: ',CHS.Cylinder);
         Write(' Head: ',CHS.Head);
         Write(' Sector: ',CHS.Sector);
         Writeln;
      End;
End.
