;386 Protected Mode structures include file
;written by John Baldwin for Phoenix Systems, Inc. (name?), 1997

DISPLAY "    Protected Mode Structures and Equates"

PrivilegeLevel0         EQU  0         ;privilege levels for CPL, RPL, and
PrivilegeLevel1         EQU  1         ;IOPL
PrivilegeLevel2         EQU  2         ;
PrivilegeLevel3         EQU  3         ;

;short-hand versions of priviledge levels

IRP PLNum, <0,1,2,3>

PL&PLNum                EQU  PLNum     ;;PLx EQU x

ENDM

PageSize                EQU  4096      ;number of bytes per page (no
                                       ;extensions enabled)

;Generic Selector type

Selector_Descriptor     EQU  11111000b ;Index of selector's descriptor in respective table
Selector_Table          EQU  00000100b ;Used to indicate which table is to be accessed
Selector_RPL            EQU  00000011b ;RPL of selector

Selector_GDT            EQU  00000000b ;Table = GDT
Selector_LDT            EQU  00000100b ;Table = LDT

;Flags in Memory Descriptors

DescMemFlags_Present    EQU  10000000b ;is descriptor present
DescMemFlags_DPL        EQU  01100000b ;mask for descriptor DPL
DescMemFlags_DPL_Shift  EQU  5         ;number of left shifts to get DPL in place
DescMemFlags_SegType    EQU  00010000b ;is segment memory or system?
DescMemFlags_Type       EQU  00001110b ;descriptor type (gate, trap, etc.)
DescMemFlags_Accessed   EQU  00000001b ;accessed or not (read or written=accessed)

DescMemFlags_NotPresent EQU  00000000b ;not present
DescMemFlags_MemSegment EQU  00010000b ;segment is a memory segment
DescMemFlags_SysSegment EQU  00000000b ;segment is a system segment
DescMemFlags_ReadOnly            EQU  00000000b ;
DescMemFlags_ReadWrite           EQU  00000010b ;
DescMemFlags_ReadOnlyExpandDown  EQU  00000100b ;
DescMemFlags_ReadWriteExpandDown EQU  00000110b ;
DescMemFlags_ExecuteOnly         EQU  00001000b ;
DescMemFlags_ExecuteRead         EQU  00001010b ;
DescMemFlags_ExecuteOnlyConform  EQU  00001100b ;
DescMemFlags_ExecuteReadConform  EQU  00001110b ;
DescMemFlags_NotAccessed EQU 00000000b ;segment has not been accessed

;Flags in system descriptors


;Flags in all descriptors (except DT descriptors)

DescSegFlags_Granularity EQU 10000000b ;limit measured in bytes or pages
DescSegFlags_Size       EQU  01000000b ;D-bit, 16-bit or 32-bit
DescSegFlags_Reserved   EQU  00100000b ;this bit should be 0
DescSegFlags_Available  EQU  00010000b ;available for use
DescSegFlags_LimitHi    EQU  00001111b ;High 4 bits of segment limit

DescSegFlags_ByteGranular EQU 00000000b ;segment is byte granular
DescSegFlags_PageGranular EQU 10000000b ;segment is page granular
DescSegFlags_Seg16      EQU  00000000b ;16-bit segment
DescSegFlags_Seg32      EQU  01000000b ;32-bit segment

;Descriptor structure

STRUC Descriptor
  SegmentLimitLow           DW  ?      ;low 16 bits of segment limit (size)
  SegmentBaseLow            DW  ?      ;low 24 bits of segment base linear address
  SegmentBaseLow2           DB  ?
  TypeFlags                 DB  ?      ;segment type-specific flags (Mem Flags, Sys Flags)
  GeneralFlags              DB  ?      ;segment-general flags (Seg Flags)
  SegmentBaseHigh           DB  ?      ;high 8 bits of segment base linear address
ENDS

;Structure of a DT descriptor (descriptor table descriptor)

STRUC DescTableDescriptor
   TableSize                DW  ?      ;size of table in bytes, max 64k
   TableAddress             DD  ?      ;physical address of table
ENDS
