MODEL Large
IDEAL
P386

;Routines to display video in text mode while in Protected Mode
;Note: these routines are in a 32-bit code segment
;Written by John Baldwin 1997

TEXT_SEG_BASE EQU  0B8000h
TEXT_SEG_LIMIT EQU 00FFFFh

SEGMENT   _PMDATA Word  Public 'PMDATA'

VideoOffset DD    ?                     ;current offset in Video Mem
XSize     DD      ?                     ;number of bytes per row in Video
                                        ;Memory (Columns * 2)
YSize     DD      ?                     ;number of rows
VideoSeg  DW      ?                     ;Selector for Video Mem

ENDS

ASSUME    CS:_TEXT32, DS:_PMDATA

SEGMENT   _TEXT32 Byte  Public Use32 'CODE'

PUBLIC    VideoInit, ClearScreen, SetXY, NextLine, ScrollUp, PrintLine

;Call With: AX  = Selector for Video Offset
;           ECX = Number of Columns
;           EDX = Number of Rows
;
;Returns: 
;
;Trashes: ECX
;
;initializes the Video data segment

PROC      VideoInit NEAR

          shl     ecx,1                 ;multiply columns by 2
          mov     [VideoSeg],ax         ;save selector for Video Mem
          mov     [XSize],ecx           ;save XSize and YSize
          mov     [YSize],edx
          mov     [VideoOffset],0       ;home cursor
          retn

ENDP

;Call With: Nothing
;
;Returns: Nothing
;
;Trashes: EAX, ECX, EDI
;
;clears the screen and homes the cursor

PROC      ClearScreen NEAR

          push    es                    ;save ES
          xor     edi,edi               ;set EDI = 0
          mov     es,[VideoSeg]         ;ES -> Video Segment
          mov     eax,07200720h         ;Fill EAX with data for space
                                        ;character and light gray on black
          mov     [VideoOffset],edi     ;set VideoOffset to 0 (homes cursor)
          mov     ecx,[XSize]
          imul    ecx,[YSize]           ;CX = XSize*YSize, also = number of
                                        ;bytes to write, which will always
                                        ;be even, BTW
          shr     ecx,2                 ;writing DWords, don't check for
                                        ;carry assuming that there are an
                                        ;even number of characters
          cld                           ;going forward
          rep     stosd                 ;clear video memory
          pop     es                    ;restore es
          retn

ENDP

;Call With: ECX = X
;           EDX = Y
;Returns: Nothing
;
;Trashes: ECX, EDX
;
;Move cursor to (X,Y) on screen, (0,0) is home position

PROC      SetXY   NEAR

          shl     ecx,1                 ;multiply X by 2
          imul    edx,[XSize]           
          add     ecx,edx               ;ECX = (X*2)+(Y*XSize)
          mov     [VideoOffset],ecx     ;save new video offset
          retn
ENDP

;Call With: nothing
;
;Returns: nothing
;
;Trashes: EAX, EDX, ESI, EDI
;
;Moves the cursor to the start of the next line, if the current line is the
;bottom of the screen, then it scrolls the display up one line and moves to
;the start of the last line, imitating a teletype terminal

PROC      NextLine NEAR

          mov     eax,[VideoOffset]
          xor     edx,edx               ;EDX:EAX = Video Offset
          div     [XSize]               ;EAX now = current Y
          inc     eax                   ;go to next line
          cmp     eax,[YSize]           ;see if we are below the bottom
          jbe     @@Normal              ;if not skip down to below
          push    eax                   ;save EAX
          call    ScrollUp              ;scroll the screen up one line
          pop     eax                   ;restore EAX
          dec     eax                   ;go back up to the last line on
                                        ;the screen
@@Normal: imul    eax,[XSize]           ;multiply by XSize to get offset for
                                        ;for start of line EAX
          mov     [VideoOffset],eax     ;save Video Offset
          retn
ENDP

;Call With:
;
;Returns:
;
;Trashes: EAX, EDI, ESI
;
;Moves the contents of the screen up one line.

PROC      ScrollUp NEAR

          push    es
          xor     edi,edi
          mov     es,[VideoSeg]
          mov     ecx,[YSize]
          mov     esi,[VideoOffset]
          dec     ecx
          imul    ecx,[XSize]
          shr     ecx,2
          cld
          rep     movs [DWORD es:edi],[DWORD es:esi]
          mov     eax,07200720h          
          mov     ecx,[XSize]
          sub     [VideoOffset],ecx
          shr     ecx,2
          rep     stosd
          pop     es
          retn

ENDP

;Call With: FS:ESI -> ASCIIZ String to print (#10 = CR/LF)
;
;Returns: Nothing
;
;Trashes: EAX, EDX, EDI, ESI

PROC      PrintLine NEAR
          
          push    es
          mov     es,[VideoSeg]
          mov     ah,07h
          mov     edi,[VideoOffset]
          cld
@@Top:    lods    [BYTE fs:esi]          
          or      al,al
          jz      @@End
          cmp     al,10
          jz      @@LF
          stos    [WORD es:edi]
          jmp     @@Top
@@LF:     push    eax
          push    esi
          call    NextLine
          mov     edi,[VideoOffset]
          pop     esi
          pop     eax
          jmp     @@Top
@@End:    mov     [VideoOffset],edi
          pop     es
          retn

ENDP

ENDS

END
